//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2017 Autodesk, Inc.  All rights reserved.
//
//  Use of this software is subject to the terms of the Autodesk license 
//  agreement provided at the time of installation or download, or which 
//  otherwise accompanies this software in either electronic or hard copy form.   
//
//////////////////////////////////////////////////////////////////////////////

#include "TexmapButton.h"
#include <pbbitmap.h>

#include "../../include/3dsmax_banned.h"

TexmapButton::TexmapButton(QWidget* parent)
    : QPushButton(parent)
    , m_smallLabel(false)
    , m_connected(true)
    , m_map(false)
{
    setAcceptDrops(true);
}

void TexmapButton::setSmallLabel(bool labelSize)
{
    m_smallLabel = labelSize;
}

void TexmapButton::setConnected(bool connected)
{
    m_connected = connected;
    update();
}

void TexmapButton::hasMap(bool map)
{
    m_map = map;
    update();
}

void TexmapButton::paintEvent(QPaintEvent * event)
{
    QString currentText = text();
    QString newText = "";
    if (m_smallLabel) 
    {
        if (m_map)
            newText = m_connected ? tr("M") : tr("m");
    }
    else 
    {
        newText = currentText;
        QFontMetrics fm(font());
        int len = newText.length();
        int maxWidth = width() - 20;
        while (fm.width(newText) > maxWidth)
            newText.truncate(--len);
    }

    if (currentText != newText)
        setText(newText);

    QPushButton::paintEvent(event);
}
